<?php
require_once("stormwareDB.php");
if (isset($_GET["fileUrl"])) {
    $fileUrl=$_GET["fileUrl"];
    $d2b = new Html2dbf();
    $filename=basename($fileUrl);
    $filename=substr($filename, 0, 2);    
    $d2b->createDB($filename);
    $d2b->parse($fileUrl);
    $d2b->closeDB();
    echo "year=".$d2b->year;    
}

?>
<!-- Formul pro zadn souboru
 -->
<form action="html2dbf.php">
Cesta k HTML souboru: <input name="fileUrl" value="<?php 
	if (isset($fileUrl)) echo $fileUrl;?>">
<input type="submit" value="Zpracuj">
</form>
<?php

class Html2dbf {
    protected $dbPoplatky;
    protected $dbPrispevky;
    protected $dbOstatni;    
    protected $dbUroky;
        
    public $year=2006;
	public $month;
    protected $td_nr=0;
    protected $payments;
    protected $record=array();
    
    /** Funkce storeData ukld data z jedn buky HTML tabulky do nkter poloky struktury "record" */
    protected function storeData($matchesTD) {
        
        $field=$matchesTD[1][0];
        $parts=preg_split('/<br(>|\/>)/i', $field);
        if (!isset($parts[0])) $parts[0]='';
        if (!isset($parts[1])) $parts[1]='';
        if (!isset($parts[2])) $parts[2]='';        
        switch ($this->td_nr) {
            case 0:
                $this->record['cisloVypisu']=0+$field;
                break;
            case 1:
                $this->record['datum']=$parts[0];
                $this->record['cas']=$parts[1];
                break;
            case 2:
                $this->record['text']=$parts[0];
                $this->record['jmeno']=$parts[1];
                $this->record['ucet']=$parts[2];
                break;                
            case 3:
                $this->record['datumOdpisu']=$parts[0];
                $this->record['valuta']=$parts[1];
                $this->record['typ']=$parts[2];
                break;
            case 4:
                $this->record['ss']=$parts[0];
                $this->record['vs']=$parts[1];
                $this->record['ks']=$parts[2];
                break;
            case 5:
                $castka=0.0+str_replace(array(' ', 't'),"",$field);
                $this->record['castka']=$castka;
                break;
            case 6:
                $this->record['poplatek']=$parts[0];
                $this->record['konverze']=$parts[1];
                $this->record['zprava']=$parts[2];
                break;
        }
        
        $this->td_nr++;
    }
    /**
     * saveRecord ukld do databz jeden zznam this->record, jeho hodnoty jsme si
     * naparsovali ze vstupnho HTML souboru.
     */
    protected function saveRecord() {
        $this->td_nr=0;
        
        $rec=$this->record;
        for ($i=0; $i<=68; $i++) $dbfrec[$i]="";
                
        if (isset($rec['datum'])) {        
            foreach ($rec as $index=>$value) {         // pevod z Win-1250 do:
                //$rec[$index]=iconv("windows-1250", "utf-8", $value);     // UTF-8 pro zobrazen
                if ($value=="&nbsp;") $rec852[$index]="";
                else $rec852[$index]=iconv("windows-1250", "ibm852", $value);// IBM852 pro uloen do DBF
            }            
            $mesic=substr($rec['datum'], 3, 2);
            $datum=$rec['datum'] . $this->year;            
            $cislo=sprintf("%03d/%05d", $mesic, 10*$rec['cisloVypisu']);
            $this->payments.="<tr><td>".$cislo."</td>";
            $this->payments.="<td>".$rec['text']."</td>";
            $this->payments.="<td>".$rec['jmeno']."</td>";
            $this->payments.="<td>".$rec['cas']."</td>";
            $this->payments.="<td>".$rec['ucet']."</td>";
            $this->payments.="<td>".$rec['datumOdpisu']."</td>";
            $this->payments.="<td>".$rec['valuta']."</td>";
            $this->payments.="<td>".$rec['typ']."</td>";
            $this->payments.="<td>".$rec['ss']."</td>";
            $this->payments.="<td>".$rec['vs']."</td>";
            $this->payments.="<td>".$rec['ks']."</td>";
            $this->payments.="<td>".$rec['poplatek']."</td>";
            $this->payments.="<td>".$rec['konverze']."</td>";
            $this->payments.="<td>".$rec['zprava']."</td>";
                        
            $poplatky=$rec['poplatek']+$rec['konverze']+$rec['zprava'];
            $castka=$rec['castka'];
            $dbfrec[24]=$cislo;
            $dbfrec[25]=$rec852['vs'];
            $dbfrec[27]=$rec852['text'];
            $dbfrec[28]=$this->year.$mesic.substr($rec['datum'],0,2);
            $dbfrec[29]=$this->year.substr($rec['datumOdpisu'], 3, 2).substr($rec['datumOdpisu'],0,2);
            $dbfrec[49]=$rec852['jmeno'];
            $cuctu=explode("/", $rec852['ucet']);
            $dbfrec[57]=$cuctu[0];
            if (isset($cuctu[1])) $dbfrec[58]=$cuctu[1];
            $dbfrec[59]=$rec852['ss'];
            $dbfrec[60]=$rec852['ks'];
            
            
            if ($castka==0 || ($castka!=0 && $poplatky==0)) {
                // U nkterch poplatk m ebanka v dku vpisu pouze poplatek (castka==0) - nap. u "Mimodnho zasln vpisu"
                // U rok je zase stka!=0 ale poplatek==0
                // Oba tyto ppady generuj pouze 1 zznam do databze plateb
                $castka+=$poplatky;
                $cstr=strtr("".abs($castka), ".", ",");
                $this->payments.="<td>".$cstr."</td>";                
                
                $dbfrec[37]=$dbfrec[39]=$dbfrec[32]="".abs($castka);

                if ($castka<0) {    // je to poplatek ?
                    $this->payments.="<td>Vdej</td>";
                    if ($dbfrec[27]=="") $dbfrec[27]=$rec852['typ'];    
                    $this->dbPoplatky->save($dbfrec);
                } else {            // castka>0 - tzn. je to rok
                    $this->payments.="<td>Pjem</td></tr>";
                    $this->dbUroky->save($dbfrec);                    
                }
            } else {
                // castka!=0 && poplatek !=0 - nejbnj ppad, generujc 2 zznamy do databze plateb
                $cstr=strtr("".abs($castka), ".", ",");
                $dbfrec[37]=$dbfrec[39]=$dbfrec[32]="".abs($castka);                
                $this->payments.="<td>".$cstr."</td>";                
                if ($castka<0) {
                    $this->payments.="<td>Vdej</td>";
                    $this->dbOstatni->save($dbfrec);                    
                } else {
                    $this->payments.="<td>Pjem</td></tr>";
                    $dbfrec[27]=str_ireplace("internetu", "", $dbfrec[27]);
                    $dbfrec[27]=str_ireplace("internet", "", $dbfrec[27]);                    
                    $dbfrec[27]=iconv("windows-1250", "ibm852", "lensk pspvek: ").$dbfrec[27];
                    $this->dbPrispevky->save($dbfrec);                                                            
                }
                
                $cislo=sprintf("%03d/%05d", $mesic, 10*$rec['cisloVypisu']+1);
                $this->payments.="<tr><td>".$cislo."</td>";
                $this->payments.="<td>Bankovni poplatek</td>";
                $this->payments.="<td>".$rec['jmeno']."</td>";
                $this->payments.="<td>".$rec['cas']."</td>";
                $this->payments.="<td>".$rec['ucet']."</td>";
                $this->payments.="<td>".$rec['datumOdpisu']."</td>";
                $this->payments.="<td>".$rec['valuta']."</td>";
                $this->payments.="<td>".$rec['typ']."</td>";
                $this->payments.="<td>".$rec['ss']."</td>";
                $this->payments.="<td>".$rec['vs']."</td>";
                $this->payments.="<td>".$rec['ks']."</td>";
                $this->payments.="<td>".$rec['poplatek']."</td>";
                $this->payments.="<td>".$rec['konverze']."</td>";
                $this->payments.="<td>".$rec['zprava']."</td>";            
                $cstr=strtr("".abs($poplatky), ".", ",");
                $this->payments.="<td>".$cstr."</td>";                
                $this->payments.="<td>Vdej</td></tr>";                            
                $dbfrec[24]=$cislo;                                
                $dbfrec[27]="Bankovni poplatek";                 
                $dbfrec[37]=$dbfrec[39]=$dbfrec[32]="".abs($poplatky);                
                $this->dbPoplatky->save($dbfrec);                
            }
            
        
        } //     if (isset($rec['datum'])) {        
		if (isset($cislo)) echo "Zaznam $cislo uloen...<BR>";
    }

    public function parse($file) {
        /**
         * Parser pouziva regulrn vraz jako zjednoduen
         * - nen tak poteba lexikalni analyzer.
         *
         * PATTERN_TR je regularni vyraz pro case-insensitive hledani znacek <tr>
         * S pouitim preg_match_all pak ziskame vsechny nalezene
         * vysledky ve vicerozmernem poli, kde
         * 1. rozmer indexuje jednotlive podvyrazy reg. vyrazu - ns bude zajimat:
         *  podvyraz c. 1 - znacka, napr. td nebo /td
         * 2. rozmer pak indexuje jednotlive nalezence.
         */
        define('PATTERN_TR','/<(tr)(?:[^\/>]*)(?:\/>|>)/si');

        define('PATTERN_TR_TD','/<(tr|td)(?:[^\/>]*)(?:\/>|>)/si');
        /**
         * PATTERN_TD hleda bloky, ktere zacinaji znackou <td>, pokracuji libovolnym
         * textem a konci znackou </td>. Pricemz v libovolnem textu nam eBanka pripravila
         * chytak - muze tam byt vlozena vnitrni tabulka - s tou musime pocitat.
         * Vysledek preg_match_all:
         * 1. rozmer indexuje jednotlive podvyrazy
         *     podvyraz c. 1 - libovolny text mezi <td> a </td>
         *  podvyraz c. 2 - pokud se v libovolnem textu vyskytne vlozena tabulka,
         *                     pak zde dostaneme text mezi znakou <table> a </table>
         */
        //define('PATTERN_TD', '/<td(?:[^\>]*)>(.*?)(?:<table(?:[^\>]*)>(.*?)<\/table>)*?<\/td>/si');
        define('PATTERN_TD', '/<td(?:[^\>]*)>(.*?)<\/td>/si');
        
        define('START_STRING', 'Pohyby na bnm tu');
        define('STATE_START', 'start');
        define('STATE_HEADER', 'table-header');
        define('STATE_TABLE', 'table');
        define('STATE_INNERTABLE', 'innertable');
        define('STATE_TR_START', 'starting tr');
        define('STATE_TR', 'tr');
        define('STATE_TD_START', 'td start');
        define('STATE_TD', 'td');
        define('STATE_DATA', 'data');
        if (!($fp = fopen($file, 'r'))) {
            die('Nemohu nast HTML soubor '.$file);
            return false;
        }
        $state=STATE_START;             // stav konecneho automatu
        $offset=0;                        // ofset ve zpracovanem retezci, od ktereho budeme spoustet hledani reg. vyrazu
        //$startString=iconv("UTF-8", "windows-1250", START_STRING);
        $startString=START_STRING;
        while (!feof($fp)) {
            if ($state!=STATE_TD) {             // v predchozim radku bylo posledni TD spravne ukoncene
                $data = fgets($fp,4096);        // => nacteme cely radek
                $offset=0;
            } else {                            // ale pokud na konci radku BYLO neukoncene TD
                $newdata = fgets($fp,4096);
                $data.=$newdata;                // pridame k minulemu radku dalsi radek
                $match_cnt=preg_match(PATTERN_TD, $data, $matchesTD, PREG_OFFSET_CAPTURE, $offset);
                if ($match_cnt==0) continue;    // a to delej dokud nenajdes koncove </td>
                else {
                    $state=STATE_TD_START;        // jinak normalne pokracuj v analyze
                    $this->storeData($matchesTD);
                    $offset+=strlen($matchesTD[0][0]);            
                }
            }

            if ($state==STATE_START) {
                $start=stripos($data, "Bankovn vpis .");    // v mesicnich vypisech chybi u datumu rok...
                if ($start!==false)                 //najdeme si rok na zacatku
                    $this->year=substr($data, $start+36, 4);
                                                                    
                $start=stripos($data, $startString); // hledame zacatek tabulky
                if ($start!==false)     {             // nasli jsme?
                    $data=substr($data, $start+strlen($startString)); // odstranime vse po zacatek tabulky
                    $state=STATE_HEADER;            // a budeme pokracovat nize hledanim druheho <tr>
                } else continue;                    // nenasli jsme - hop zpatky na fgets
            }
            do {
                if ($state==STATE_HEADER || $state==STATE_TR_START)
                    $pattern=PATTERN_TR;
                else $pattern=PATTERN_TR_TD;
                $match_cnt=preg_match($pattern, $data, $matches, PREG_OFFSET_CAPTURE, $offset);
                if ($match_cnt>0) {                    // dokud nalezame tagy (TD|TR)
                    $match=$matches[1][0];
                    $offset=$matches[1][1]-1;
                    $offsetAdd=strlen($matches[0][0]);
                    switch ($state) {
                        case STATE_HEADER:                // 1. radek (zahlavi) tabulky ?
                            $state=STATE_TR_START;             // preskoc...
                            break;
                        case STATE_TR_START:                // 1. datovy radek tabulky ?
                            $this->saveRecord();
                            $state=STATE_TD_START;
                            break;
                        case STATE_TD_START:
                            if (strcasecmp($match, 'td')==0) {    // ano-pojdme na znacky TD!
                                //    Tady se hromadne zpracuji vsechny znacky TD v jednom radku TABLE
                                $match_cnt=preg_match(PATTERN_TD, $data, $matchesTD, PREG_OFFSET_CAPTURE, $offset);
                                // parsuj vnitrek mezi <td> a </td>
                                if ($match_cnt==0) {    // pokud jsme nic nenasli,
                                    $state=STATE_TD;    // pak je <td> neukoncene -
                                    $offsetAdd=0;            // - nacti dalsi radek ze soubor
                                } else {
                                    $this->storeData($matchesTD);    //    pak uloz vsechna nalezena data
                                    $offsetAdd=strlen($matchesTD[0][0]);
                                }
                            } else {
                                $this->saveRecord();
                                
//                                $state=STATE_TR_START;
//                                $offsetAdd=0;            // - nacti dalsi radek ze souboru                                
                            }
                            break;
                    }    // switch
                    $offset+=$offsetAdd;
                }    // if
            }    while ($match_cnt>0);
        } // while
        return true;
    }

    public function createDB($prefix) {
        $this->payments="";
        $this->dbPoplatky=new stormwareDB();
        $this->dbPoplatky->createDB($prefix."-popl.dbf");
        $this->dbUroky=new stormwareDB();
        $this->dbUroky->createDB($prefix."-urok.dbf");
        $this->dbPrispevky=new stormwareDB();
        $this->dbPrispevky->createDB($prefix."-prisp.dbf");
        $this->dbOstatni=new stormwareDB();
        $this->dbOstatni->createDB($prefix."-ostat.dbf");
    }
    
    public function closeDB() {
        dbase_close($this->dbPoplatky->dbLink);        
        dbase_close($this->dbUroky->dbLink);        
        dbase_close($this->dbPrispevky->dbLink);        
        dbase_close($this->dbOstatni->dbLink);
        //foreach ($xml as $key=>$row) {    // projdeme vsechny radky vypisu
        //echo "<p><b>dek: $key</b><p>"; print_r($row);
        //foreach ($row['elements'] as $cell) {
        //print_r($cell);
        //}
        //}

    }
}



?>